﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;
using System.Windows.Input;

namespace WpfApplication1
{
    class MyHost : FrameworkElement
    {
        public MyHost()
        {
            children = new VisualCollection(this);

            children.Add(CreateRect());
            children.Add(CreateEllipse());
            children.Add(CreateLine());



            m_ST.CenterX = 150;
            m_ST.CenterY = 150;
            m_ST.ScaleX = 1;
            m_ST.ScaleY = 1;

            m_TT.X = 0;
            m_TT.Y = 0;

            m_TG.Children.Add(m_TT);
            m_TG.Children.Add(m_ST);

            this.MouseWheel += new MouseWheelEventHandler(MyHost_MouseWheel);

            this.MouseLeftButtonDown += new MouseButtonEventHandler(MyHost_MouseLeftButtonDown);
            this.MouseLeftButtonUp += new MouseButtonEventHandler(MyHost_MouseLeftButtonUp);
            this.MouseMove += new MouseEventHandler(MyHost_MouseMove);
        }

        void MyHost_MouseMove(object sender, MouseEventArgs e)
        {
            if (isPanActive)
            {
                Point newPoint = e.GetPosition(this);

                double offsetX = newPoint.X - lastPoint.X;
                double offsetY = newPoint.Y - lastPoint.Y;

                m_TT.X += (offsetX / m_ST.ScaleX); 
                m_TT.Y += (offsetY / m_ST.ScaleY);

                m_ST.CenterX += (offsetX / m_ST.ScaleX);
                m_ST.CenterY += (offsetY / m_ST.ScaleY);

                lastPoint = newPoint;
            }
        }

        void MyHost_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            isPanActive = false;
        }

        void MyHost_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            lastPoint = e.GetPosition(this);
            isPanActive = true;
        }

        TransformGroup m_TG = new TransformGroup();
        ScaleTransform m_ST = new ScaleTransform();
        TranslateTransform m_TT = new TranslateTransform();

        void MyHost_MouseWheel(object sender, MouseWheelEventArgs e)
        {
            if (e.Delta > 0)
            {
                m_ST.ScaleX *= 1.1;
                m_ST.ScaleY *= 1.1;
            }
            else
            {
                m_ST.ScaleX /= 1.1;
                m_ST.ScaleY /= 1.1;
            }
        }

        Point lastPoint;
        bool isPanActive = false;

        DrawingVisual CreateRect()
        {
            DrawingVisual dv = new DrawingVisual();

            DrawingContext dc = dv.RenderOpen();

            RectangleGeometry geometry = new RectangleGeometry(System.Windows.SystemParameters.WorkArea);
            dc.DrawGeometry(Brushes.White, null, geometry);

            dc.Close();

            return dv;
        }

        DrawingVisual CreateEllipse()
        {
            DrawingVisual dv = new DrawingVisual();

            DrawingContext dc = dv.RenderOpen();

            EllipseGeometry geometry = new EllipseGeometry(new Point(150, 150), 140, 140);
            geometry.Transform = m_TG;
            dc.DrawGeometry(Brushes.Pink, new Pen(Brushes.Blue, 3), geometry);

            dc.Close();

            return dv;
        }

        DrawingVisual CreateLine()
        {
            DrawingVisual dv = new DrawingVisual();

            DrawingContext dc = dv.RenderOpen();

            LineGeometry geometry = new LineGeometry(new Point(150, 160), new Point(150, 5));
            geometry.Transform = m_TG;
            dc.DrawGeometry(null, new Pen(Brushes.Blue, 3), geometry);

            dc.Close();

            return dv;
        }

        private VisualCollection children;

        protected override System.Windows.Media.Visual GetVisualChild(int index)
        {
            return children[index];
        }

        protected override int VisualChildrenCount
        {
            get
            {
                return children.Count;
            }
        }
    }
}
